(*| 15:12 29/07/1995 *)
UNIT EGADOS;

{$DEFINE VGA}

INTERFACE

USES EGAVars;

PROCEDURE LoadUserFont(FontPtr: BytePointer; Size: Byte);

{$IFNDEF VGA}
PROCEDURE Load8x14Font;
{$ELSE}
PROCEDURE Load8x16Font;

PROCEDURE ReadRomFont(FontNum: Byte);
{$ENDIF}

PROCEDURE ShowFont(LoHi: Boolean; EditByte: Byte);

IMPLEMENTATION

USES Crt,Dos,EGAWait,EGAUtils;

Const
  DOSI_VIDEO=$10;

PROCEDURE LoadUserFont(FontPtr: BytePointer; Size: Byte);
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$1110;
    BH:=Size;
    BL:=0;
    CX:=256;
    DX:=0;
    BP:=Ofs(FontPtr^);
    ES:=Seg(FontPtr^);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { LoadUserFont }

{$IFNDEF VGA}
PROCEDURE Load8x14Font;
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$1130;
    BH:=2;
    Intr(DOSI_VIDEO,Regs);
    AX:=$1110;
    BH:=14;
    BL:=0;
    CX:=256;
    DX:=0;
    Intr(DOSI_VIDEO,Regs);
  END;
END;  { Load8x14Font }

PROCEDURE ReadRomFont;
BEGIN
END; { ReadRomFont }
{$ELSE}
PROCEDURE Load8x16Font;
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$1130;
    BH:=6;
    Intr(DOSI_VIDEO,Regs);
    AX:=$1110;
    BH:=16;
    BL:=0;
    CX:=256;
    DX:=0;
    Intr(DOSI_VIDEO,Regs);
  END;
END;  { Load8x16Font }

PROCEDURE ReadRomFont(FontNum: Byte);
VAR
  Regs: Registers;
  RomFont,RamFont: BytePointer;
  I,BlockSize: Integer;

  PROCEDURE Supplemental;
  VAR
    C:Byte;
  BEGIN
    IF (FontNum = 5) AND (BytesPerChar <> 14) THEN
      EXIT;
    IF (FontNum = 7) AND (BytesPerChar <> 16) THEN
      EXIT;
    REPEAT
      C := RomFont^;
      RomFont := IndexPtr(RomFont,1);
      IF C <> 0 THEN BEGIN
        RamFont := IndexPtr(FontBuffer,C*BytesPerChar);
        MOVE(RomFont^,RamFont^,BytesPerChar);
      END;
      RomFont := IndexPtr(RomFont,BytesPerChar);
    UNTIL C = 0;
  END;

BEGIN
  WITH Regs DO BEGIN
    AX:=$1130;
    BH:=FontNum;
    Intr(DOSI_VIDEO,Regs);
    CASE FontNum OF
      2   : BytesPerChar := 14;
      3,4 : BytesPerChar := 8;
      6   : BytesPerChar := 16;
    END;
    RomFont := Ptr(ES,BP);
    RamFont := FontBuffer;
    FontFileSize := BytesPerChar * 256;
    BlockSize := FontFileSize;
    IF FontNum = 3 THEN
      BlockSize := BlockSize DIV 2
    ELSE IF FontNum = 4 THEN BEGIN
      BlockSize := BlockSize DIV 2;
      RamFont := IndexPtr(FontBuffer,BlockSize);
    END;
    IF FontNum IN [5,7] THEN
      Supplemental
    ELSE
      MOVE(RomFont^,RamFont^,BlockSize);
  END;
  FontUpdated:=False;
  FontCharPtrs[0]:=Addr(FontBuffer^);
  FOR I:=1 TO MaxCharNum DO
    FontCharPtrs[I]:=IndexPtr(FontCharPtrs[0],(I*BytesPerChar));
END;  { ReadRomFont }
{$ENDIF}

PROCEDURE VidWr(B: Byte);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AH := 3;
    Intr(DOSI_VIDEO,Regs);  {read cursor}
    AH := 2;
    DH := 0;
    DL := B;
    Intr(DOSI_VIDEO,Regs); {set cursor}
    AH := 10;
    AL := B;
    CX := 1;
    Intr(DOSI_VIDEO,Regs);  {write char}
  END;
END;  { VidWr }

PROCEDURE ShowFont(LoHi: Boolean; EditByte: Byte);
VAR
  I:Integer;
  Start: Integer;
BEGIN
  ClrScr;
  LoadUserFont(FontCharPtrs[0],BytesPerChar);
  Start := EditByte;
  IF LoHi THEN
    FOR I:=EditByte TO ((MaxCharNum+1) DIV 2) - 1 DO BEGIN
      IF I MOD 16 = 0 THEN
        Writeln;
      Write(CHR(I),CHR(I+$80),'  ');
    END
  ELSE BEGIN
    IF EditByte = 0 THEN BEGIN
      FOR I := 0 TO $1F DO
        VidWr(I);
      Start := $20;
    END;
    FOR I:=Start TO MaxCharNum DO BEGIN
      IF Start=$20 THEN IF I MOD $20 = 0 THEN
        Writeln;
      Write(CHR(I));
    END;
  END;
  Writeln;
  PauseRdKey;
{$IFNDEF VGA}
  Load8x14Font;
{$ELSE}
  Load8x16Font;
{$ENDIF}
END;

END.
